<?php
/**
 * @file       mod_ga2win.php
 * @brief      Multi Sites Google Analytics.
 * @version    1.1.1
 * @author     Edwin CHERONT     (e.cheront@jms2win.com)
 *             Edwin2Win sprlu   (www.jms2win.com)
 * @copyright  Joomla Multi Sites Google Analytics.
 *             (C) 2008-2013 Edwin2Win sprlu - all right reserved.
 * @license    This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License
 *             as published by the Free Software Foundation; either version 2
 *             of the License, or (at your option) any later version.
 *             This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *             GNU General Public License for more details.
 *             You should have received a copy of the GNU General Public License
 *             along with this program; if not, write to the Free Software
 *             Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *             A full text version of the GNU GPL version 2 can be found in the LICENSE.php file.
 * @par History:
 * - V1.0.1 14-JAN-2011: Add cross-check that function is not already declared.
 *                       Also contain the new Google Analytic script.
 * - V1.0.2 07-MAR-2011: Add Joomla 1.6 compatibility
 * - V1.1.0 09-JUN-2012: Add the possibility to select the tracking type and possibility to add the code in the head section
 * - V1.1.1 08-AUG-2013: Add Joomla 3.x compatibility - Packaged with a manifest file compatible with Joomla 2.5 / 3.x
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


//------------ fn_ga2win ---------------
/**
 * @brief Google Analytics processing to make all variables defined locally
 */
if ( !function_exists( 'fn_ga2win')) {
function fn_ga2win( $params)
{
   $trackerList   = $params->get('trackerList', '');
   $tracking_type = $params->get('tracking_type', 'single');
   $position      = $params->get('position', 'head');
   if ( !empty( $trackerList))
   {
      $uri  =& JFactory::getURI();
      $host = strtolower( $uri->toString( array('host')));
      $ga_default = '';
      $trackerId  = '';
      $lines = explode( "\n", $trackerList);
      foreach( $lines as $line) {
         $line = trim( $line);
         // Skip empty lines
         if ( empty( $line)) {
            continue;
         }
         // If there is no '=' sign, this is a default value
         if ( strstr( $line, '=') === false) {
            $ga_default = trim( $line);
         }
         else {
            // Parse statment key=value
            $statement = explode( '=', $line);
            if ( !empty( $statement) && count($statement)==2) {
               $key   = strtolower( trim( $statement[0]));
               $value = trim( $statement[1]);
               // If it match the current host name
               if ( $key == $host) {
                  // OK, we found the tracker id
                  $trackerId = $value;
                  break;
               }
               // Check if this a default domain (=...);
               if ( empty( $key) && !empty( $value)) {
                  $ga_default = $value;
               }
            }
         }
      }
      
      // If the GA Tracker ID is not found and a default one exist, use it
      if ( empty( $trackerId) && !empty( $ga_default)) {
         $trackerId = $ga_default;
      }
      
      // Finally, if the GA Tracker ID is found,
      if ( !empty( $trackerId)) {
         // If the script must be added in the <head> section
         if ( $position == 'head') {
            ob_start();
            // Insert the Google Analytics template code
            require( JModuleHelper::getLayoutPath('mod_ga2win', $tracking_type));
            $script = ob_get_contents();
            ob_end_clean();
            JFactory::getDocument()->addScriptDeclaration( trim( str_replace( array( '<script type="text/javascript">', '</script>'), '', $script)));
         }
         else {
            // Insert the Google Analytics template code
            require( JModuleHelper::getLayoutPath('mod_ga2win', $tracking_type));
         }
      }
   }
}
}

fn_ga2win( $params);


?>
